#include <stubs.h>
/* Dia -- a diagram creation/manipulation program
 * Copyright (C) 1998 Alexander Larsson
 *
 * sheets_dialog.c : a sheets and objects dialog
 * Copyright (C) 2002 M.C. Nelson
 *  
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *  
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *  
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *  
 */

/*
 * DO NOT EDIT THIS FILE - it is generated by Glade and then hand-coded
 *                         to make GNOME optional and add the underline
 *                         for accelerated buttons.
 */

#ifdef HAVE_CONFIG_H
//#  include <config.h>
#endif

//#include <sys/types.h>
#ifdef HAVE_UNISTD_H
//#  include <unistd.h>
#endif
//#include <string.h>

//#include <gtk/gtk.h>
//#include <gdk/gdkkeysyms.h>

//#include "sheets.h"
//#include "sheets_dialog_callbacks.h"
//#include "sheets_dialog.h"

//#include "intl.h"
//#include "persistence.h"

GtkWidget*
create_sheets_main_dialog (void)
{
  GtkWidget *sheets_main_dialog;
  GtkWidget *dialog_vbox1;
  GtkWidget *table_sheets;
  GtkWidget *vbuttonbox;
  GtkWidget *button_copy;
  GtkWidget *button_copy_all;
  GtkWidget *button_move;
  GtkWidget *button_move_all;
  GtkWidget *optionmenu_right;
  GtkWidget *optionmenu_right_menu;
  GtkWidget *optionmenu_left;
  GtkWidget *optionmenu_left_menu;
  GtkWidget *glade_menuitem;
  GtkWidget *scrolledwindow_left;
  GtkWidget *scrolledwindow_right;
  GtkWidget *dialog_action_area1;
  GtkWidget *hbox1;
  GtkWidget *button_new;
  GtkWidget *button_move_up;
  GtkWidget *button_move_down;
  GtkWidget *button_edit;
  GtkWidget *button_remove;
  GtkWidget *button_apply;
  GtkWidget *button_revert;
  GtkWidget *button_close;
  GtkAccelGroup *accel_group;

  accel_group = gtk_accel_group_new ();

  sheets_main_dialog = gtk_dialog_new ();
  gtk_object_set_data (GTK_OBJECT (sheets_main_dialog), "sheets_main_dialog", sheets_main_dialog);
  gtk_window_set_title (GTK_WINDOW (sheets_main_dialog), _("Sheets and Objects"));
  gtk_window_set_role(GTK_WINDOW(sheets_main_dialog), "sheets_main_dialog");
  gtk_window_set_default_size (GTK_WINDOW (sheets_main_dialog), 506, 261);
  gtk_window_set_resizable (GTK_WINDOW (sheets_main_dialog), TRUE);

  dialog_vbox1 = GTK_DIALOG (sheets_main_dialog)->vbox;
  gtk_object_set_data (GTK_OBJECT (sheets_main_dialog), "dialog_vbox1", dialog_vbox1);
  gtk_widget_show (dialog_vbox1);

  table_sheets = gtk_table_new (2, 3, FALSE);
  gtk_widget_ref (table_sheets);
  gtk_object_set_data_full (GTK_OBJECT (sheets_main_dialog), "table_sheets", table_sheets,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (table_sheets);
  gtk_box_pack_start (GTK_BOX (dialog_vbox1), table_sheets, TRUE, TRUE, 0);

  vbuttonbox = gtk_vbutton_box_new ();
  gtk_widget_ref (vbuttonbox);
  gtk_object_set_data_full (GTK_OBJECT (sheets_main_dialog), "vbuttonbox", vbuttonbox,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (vbuttonbox);
  gtk_table_attach (GTK_TABLE (table_sheets), vbuttonbox, 1, 2, 1, 2,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL), 17, 0);
  gtk_button_box_set_layout (GTK_BUTTON_BOX (vbuttonbox), GTK_BUTTONBOX_SPREAD);

  button_copy = gtk_button_new_with_label (_("<- Copy"));
  gtk_widget_ref (button_copy);
  gtk_object_set_data_full (GTK_OBJECT (sheets_main_dialog), "button_copy", button_copy,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (button_copy);
  gtk_container_add (GTK_CONTAINER (vbuttonbox), button_copy);
  gtk_widget_add_accelerator (button_copy, "clicked", accel_group,
                              GDK_c, GDK_CONTROL_MASK,
                              GTK_ACCEL_VISIBLE);

  button_copy_all = gtk_button_new_with_label (_("<- Copy All"));
  gtk_widget_ref (button_copy_all);
  gtk_object_set_data_full (GTK_OBJECT (sheets_main_dialog), "button_copy_all", button_copy_all,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (button_copy_all);
  gtk_container_add (GTK_CONTAINER (vbuttonbox), button_copy_all);

  button_move = gtk_button_new_with_label (_("<- Move"));
  gtk_widget_ref (button_move);
  gtk_object_set_data_full (GTK_OBJECT (sheets_main_dialog), "button_move", button_move,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (button_move);
  gtk_container_add (GTK_CONTAINER (vbuttonbox), button_move);
  gtk_widget_add_accelerator (button_move, "clicked", accel_group,
                              GDK_m, GDK_CONTROL_MASK,
                              GTK_ACCEL_VISIBLE);

  button_move_all = gtk_button_new_with_label (_("<- Move All"));
  gtk_widget_ref (button_move_all);
  gtk_object_set_data_full (GTK_OBJECT (sheets_main_dialog), "button_move_all", button_move_all,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (button_move_all);
  gtk_container_add (GTK_CONTAINER (vbuttonbox), button_move_all);

  optionmenu_right = gtk_option_menu_new ();
  gtk_widget_ref (optionmenu_right);
  gtk_object_set_data_full (GTK_OBJECT (sheets_main_dialog), "optionmenu_right", optionmenu_right,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (optionmenu_right);
  gtk_table_attach (GTK_TABLE (table_sheets), optionmenu_right, 2, 3, 0, 1,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (GTK_FILL), 0, 0);
  optionmenu_right_menu = gtk_menu_new ();
  gtk_option_menu_set_menu (GTK_OPTION_MENU (optionmenu_right), optionmenu_right_menu);

  optionmenu_left = gtk_option_menu_new ();
  gtk_widget_ref (optionmenu_left);
  gtk_object_set_data_full (GTK_OBJECT (sheets_main_dialog), "optionmenu_left", optionmenu_left,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (optionmenu_left);
  gtk_table_attach (GTK_TABLE (table_sheets), optionmenu_left, 0, 1, 0, 1,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (GTK_FILL), 0, 0);
  optionmenu_left_menu = gtk_menu_new ();
  glade_menuitem = gtk_menu_item_new_with_label ("");
  gtk_widget_show (glade_menuitem);
  gtk_menu_append (GTK_MENU (optionmenu_left_menu), glade_menuitem);
  gtk_option_menu_set_menu (GTK_OPTION_MENU (optionmenu_left), optionmenu_left_menu);

  scrolledwindow_left = gtk_scrolled_window_new (NULL, NULL);
  gtk_widget_ref (scrolledwindow_left);
  gtk_object_set_data_full (GTK_OBJECT (sheets_main_dialog), "scrolledwindow_left", scrolledwindow_left,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (scrolledwindow_left);
  gtk_table_attach (GTK_TABLE (table_sheets), scrolledwindow_left, 0, 1, 1, 2,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (GTK_FILL), 0, 0);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwindow_left), GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);

  scrolledwindow_right = gtk_scrolled_window_new (NULL, NULL);
  gtk_widget_ref (scrolledwindow_right);
  gtk_object_set_data_full (GTK_OBJECT (sheets_main_dialog), "scrolledwindow_right", scrolledwindow_right,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (scrolledwindow_right);
  gtk_table_attach (GTK_TABLE (table_sheets), scrolledwindow_right, 2, 3, 1, 2,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (GTK_FILL), 0, 0);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwindow_right), GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);

  dialog_action_area1 = GTK_DIALOG (sheets_main_dialog)->action_area;
  gtk_object_set_data (GTK_OBJECT (sheets_main_dialog), "dialog_action_area1", dialog_action_area1);
  gtk_widget_show (dialog_action_area1);
  gtk_container_set_border_width (GTK_CONTAINER (dialog_action_area1), 10);

  hbox1 = gtk_hbox_new (TRUE, 0);
  gtk_widget_ref (hbox1);
  gtk_object_set_data_full (GTK_OBJECT (sheets_main_dialog), "hbox1", hbox1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hbox1);
  gtk_box_pack_start (GTK_BOX (dialog_action_area1), hbox1, TRUE, TRUE, 0);

  button_new = gtk_button_new_from_stock(GTK_STOCK_NEW);
  gtk_widget_ref (button_new);
  gtk_object_set_data_full (GTK_OBJECT (sheets_main_dialog), "button_new", button_new,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (button_new);
  gtk_box_pack_start (GTK_BOX (hbox1), button_new, FALSE, TRUE, 0);
  gtk_widget_add_accelerator (button_new, "clicked", accel_group,
                              GDK_n, GDK_CONTROL_MASK,
                              GTK_ACCEL_VISIBLE);

  button_move_up = gtk_button_new_from_stock (GTK_STOCK_GO_UP);
  gtk_widget_ref (button_move_up);
  gtk_object_set_data_full (GTK_OBJECT (sheets_main_dialog), "button_move_up", button_move_up,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (button_move_up);
  gtk_box_pack_start (GTK_BOX (hbox1), button_move_up, FALSE, TRUE, 0);
  gtk_widget_add_accelerator (button_move_up, "clicked", accel_group,
                              GDK_u, GDK_CONTROL_MASK,
                              GTK_ACCEL_VISIBLE);
  button_move_down = gtk_button_new_from_stock (GTK_STOCK_GO_DOWN);
  gtk_widget_ref (button_move_down);
  gtk_object_set_data_full (GTK_OBJECT (sheets_main_dialog), "button_move_down", button_move_down,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (button_move_down);
  gtk_box_pack_start (GTK_BOX (hbox1), button_move_down, FALSE, TRUE, 0);
  gtk_widget_add_accelerator (button_move_down, "clicked", accel_group,
                              GDK_d, GDK_CONTROL_MASK,
                              GTK_ACCEL_VISIBLE);

  button_edit = gtk_button_new(); /* _with_label (_("Edit")); */
  {
    GtkWidget *label;

    label = gtk_label_new(_("Edit"));
    gtk_widget_ref(label);
    gtk_label_parse_uline(GTK_LABEL(label), _("_Edit"));
    gtk_container_add(GTK_CONTAINER(button_edit), label);
    gtk_widget_show(label);
  }
  gtk_widget_ref (button_edit);
  gtk_object_set_data_full (GTK_OBJECT (sheets_main_dialog), "button_edit", button_edit,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (button_edit);
  gtk_box_pack_start (GTK_BOX (hbox1), button_edit, FALSE, TRUE, 0);
  gtk_widget_add_accelerator (button_edit, "clicked", accel_group,
                              GDK_e, GDK_CONTROL_MASK,
                              GTK_ACCEL_VISIBLE);

  button_remove = gtk_button_new_from_stock(GTK_STOCK_REMOVE);
  gtk_widget_ref (button_remove);
  gtk_object_set_data_full (GTK_OBJECT (sheets_main_dialog), "button_remove", button_remove,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (button_remove);
  gtk_box_pack_start (GTK_BOX (hbox1), button_remove, FALSE, TRUE, 0);
  gtk_widget_add_accelerator (button_remove, "clicked", accel_group,
                              GDK_r, GDK_CONTROL_MASK,
                              GTK_ACCEL_VISIBLE);

  button_apply = gtk_button_new_from_stock(GTK_STOCK_APPLY);
  gtk_widget_ref (button_apply);
  gtk_object_set_data_full (GTK_OBJECT (sheets_main_dialog), "button_apply", button_apply,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (button_apply);
  gtk_box_pack_start (GTK_BOX (hbox1), button_apply, FALSE, TRUE, 0);
  gtk_widget_set_sensitive (button_apply, FALSE);

  button_revert = gtk_button_new_with_label(_("Revert"));
  gtk_widget_ref (button_revert);
  gtk_object_set_data_full (GTK_OBJECT (sheets_main_dialog), "button_revert", button_revert,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (button_revert);
  gtk_box_pack_start (GTK_BOX (hbox1), button_revert, FALSE, TRUE, 0);
  gtk_widget_set_sensitive (button_revert, FALSE);

  button_close = gtk_button_new_from_stock(GTK_STOCK_CLOSE);
  gtk_widget_ref (button_close);
  gtk_object_set_data_full (GTK_OBJECT (sheets_main_dialog), "button_close", button_close,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (button_close);
  gtk_box_pack_start (GTK_BOX (hbox1), button_close, FALSE, TRUE, 0);

  g_signal_connect (GTK_OBJECT (sheets_main_dialog), "delete_event",
                      G_CALLBACK (on_sheets_main_dialog_delete_event),
                      NULL);
  g_signal_connect (GTK_OBJECT (button_copy), "clicked",
                      G_CALLBACK (on_sheets_dialog_button_copy_clicked),
                      NULL);
  g_signal_connect (GTK_OBJECT (button_copy_all), "clicked",
                      G_CALLBACK (on_sheets_dialog_button_copy_all_clicked),
                      NULL);
  g_signal_connect (GTK_OBJECT (button_move), "clicked",
                      G_CALLBACK (on_sheets_dialog_button_move_clicked),
                      NULL);
  g_signal_connect (GTK_OBJECT (button_move_all), "clicked",
                      G_CALLBACK (on_sheets_dialog_button_move_all_clicked),
                      NULL);
  g_signal_connect (GTK_OBJECT (button_new), "clicked",
                      G_CALLBACK (on_sheets_dialog_button_new_clicked),
                      NULL);
  g_signal_connect (GTK_OBJECT (button_move_up), "clicked",
                      G_CALLBACK (on_sheets_dialog_button_move_up_clicked),
                      NULL);
  g_signal_connect (GTK_OBJECT (button_move_down), "clicked",
                      G_CALLBACK (on_sheets_dialog_button_move_down_clicked),
                      NULL);
  g_signal_connect (GTK_OBJECT (button_edit), "clicked",
                      G_CALLBACK (on_sheets_dialog_button_edit_clicked),
                      NULL);
  g_signal_connect (GTK_OBJECT (button_remove), "clicked",
                      G_CALLBACK (on_sheets_dialog_button_remove_clicked),
                      NULL);
  g_signal_connect (GTK_OBJECT (button_apply), "clicked",
                      G_CALLBACK (on_sheets_dialog_button_apply_clicked),
                      NULL);
  g_signal_connect (GTK_OBJECT (button_revert), "clicked",
                      G_CALLBACK (on_sheets_dialog_button_revert_clicked),
                      NULL);
  g_signal_connect (GTK_OBJECT (button_close), "clicked",
                      G_CALLBACK (on_sheets_dialog_button_close_clicked),
                      NULL);

  gtk_window_add_accel_group (GTK_WINDOW (sheets_main_dialog), accel_group);

  persistence_register_window(GTK_WINDOW(sheets_main_dialog));

  return sheets_main_dialog;
}

GtkWidget*
create_sheets_new_dialog (void)
{
  GtkWidget *sheets_new_dialog;
  GtkWidget *dialog_vbox2;
  GtkWidget *Typefg;
  GtkWidget *table1;
  GtkWidget *button_browse;
  GSList *table1_group = NULL;
  GtkWidget *radiobutton_svg_shape;
  GtkWidget *combo_from_file;
  GtkWidget *combo_entry_from_file;
  GtkWidget *label_description;
  GtkWidget *radiobutton_sheet;
  GtkWidget *entry_sheet_name;
  GtkWidget *radiobutton_line_break;
  GtkWidget *entry_svg_description;
  GtkWidget *entry_sheet_description;
  GtkWidget *label_svg_description;
  GtkWidget *dialog_action_area2;
  GtkWidget *hbuttonbox1;
  GtkWidget *button_ok;
  GtkWidget *button_cancel;

  sheets_new_dialog = gtk_dialog_new ();
  gtk_object_set_data (GTK_OBJECT (sheets_new_dialog), "sheets_new_dialog", sheets_new_dialog);
  gtk_window_set_title (GTK_WINDOW (sheets_new_dialog), _("New"));
  gtk_window_set_role (GTK_WINDOW (sheets_new_dialog), "sheets_new_dialog");
  gtk_window_set_resizable (GTK_WINDOW (sheets_new_dialog), FALSE);

  dialog_vbox2 = GTK_DIALOG (sheets_new_dialog)->vbox;
  gtk_object_set_data (GTK_OBJECT (sheets_new_dialog), "dialog_vbox2", dialog_vbox2);
  gtk_widget_show (dialog_vbox2);

  Typefg = gtk_frame_new (_("Type"));
  gtk_widget_ref (Typefg);
  gtk_object_set_data_full (GTK_OBJECT (sheets_new_dialog), "Typefg", Typefg,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (Typefg);
  gtk_box_pack_start (GTK_BOX (dialog_vbox2), Typefg, TRUE, TRUE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (Typefg), 5);

  table1 = gtk_table_new (5, 4, FALSE);
  gtk_widget_ref (table1);
  gtk_object_set_data_full (GTK_OBJECT (sheets_new_dialog), "table1", table1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (table1);
  gtk_container_add (GTK_CONTAINER (Typefg), table1);

  button_browse = gtk_button_new_with_label (_("Browse..."));
  gtk_widget_ref (button_browse);
  gtk_object_set_data_full (GTK_OBJECT (sheets_new_dialog), "button_browse", button_browse,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (button_browse);
  gtk_table_attach (GTK_TABLE (table1), button_browse, 3, 4, 0, 1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 3, 0);

  radiobutton_svg_shape = gtk_radio_button_new_with_label (table1_group, _("SVG Shape:"));
  table1_group = gtk_radio_button_group (GTK_RADIO_BUTTON (radiobutton_svg_shape));
  gtk_widget_ref (radiobutton_svg_shape);
  gtk_object_set_data_full (GTK_OBJECT (sheets_new_dialog), "radiobutton_svg_shape", radiobutton_svg_shape,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (radiobutton_svg_shape);
  gtk_table_attach (GTK_TABLE (table1), radiobutton_svg_shape, 0, 1, 0, 1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (radiobutton_svg_shape), TRUE);

  combo_from_file = gtk_combo_new ();
  gtk_widget_ref (combo_from_file);
  gtk_object_set_data_full (GTK_OBJECT (sheets_new_dialog), "combo_from_file", combo_from_file,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (combo_from_file);
  gtk_table_attach (GTK_TABLE (table1), combo_from_file, 1, 3, 0, 1,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL), 0, 0);
  gtk_combo_set_case_sensitive (GTK_COMBO (combo_from_file), TRUE);

  combo_entry_from_file = GTK_COMBO (combo_from_file)->entry;
  gtk_widget_ref (combo_entry_from_file);
  gtk_object_set_data_full (GTK_OBJECT (sheets_new_dialog), "combo_entry_from_file", combo_entry_from_file,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (combo_entry_from_file);

  label_description = gtk_label_new (_("description:"));
  gtk_widget_ref (label_description);
  gtk_object_set_data_full (GTK_OBJECT (sheets_new_dialog), "label_description", label_description,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label_description);
  gtk_table_attach (GTK_TABLE (table1), label_description, 0, 1, 4, 5,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_widget_set_sensitive (label_description, FALSE);
  gtk_label_set_justify (GTK_LABEL (label_description), GTK_JUSTIFY_RIGHT);
  gtk_misc_set_alignment (GTK_MISC (label_description), 0.77, 0.5);

  radiobutton_sheet = gtk_radio_button_new_with_label (table1_group, _("Sheet name:"));
  table1_group = gtk_radio_button_group (GTK_RADIO_BUTTON (radiobutton_sheet));
  gtk_widget_ref (radiobutton_sheet);
  gtk_object_set_data_full (GTK_OBJECT (sheets_new_dialog), "radiobutton_sheet", radiobutton_sheet,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (radiobutton_sheet);
  gtk_table_attach (GTK_TABLE (table1), radiobutton_sheet, 0, 1, 3, 4,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);

  entry_sheet_name = gtk_entry_new ();
  gtk_widget_ref (entry_sheet_name);
  gtk_object_set_data_full (GTK_OBJECT (sheets_new_dialog), "entry_sheet_name", entry_sheet_name,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (entry_sheet_name);
  gtk_table_attach (GTK_TABLE (table1), entry_sheet_name, 1, 3, 3, 4,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_widget_set_usize (entry_sheet_name, 255, -2);
  gtk_widget_set_sensitive (entry_sheet_name, FALSE);

  radiobutton_line_break = gtk_radio_button_new_with_label (table1_group, _("Line Break"));
  table1_group = gtk_radio_button_group (GTK_RADIO_BUTTON (radiobutton_line_break));
  gtk_widget_ref (radiobutton_line_break);
  gtk_object_set_data_full (GTK_OBJECT (sheets_new_dialog), "radiobutton_line_break", radiobutton_line_break,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (radiobutton_line_break);
  gtk_table_attach (GTK_TABLE (table1), radiobutton_line_break, 0, 1, 2, 3,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);

  entry_svg_description = gtk_entry_new ();
  gtk_widget_ref (entry_svg_description);
  gtk_object_set_data_full (GTK_OBJECT (sheets_new_dialog), "entry_svg_description", entry_svg_description,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (entry_svg_description);
  gtk_table_attach (GTK_TABLE (table1), entry_svg_description, 1, 3, 1, 2,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);

  entry_sheet_description = gtk_entry_new ();
  gtk_widget_ref (entry_sheet_description);
  gtk_object_set_data_full (GTK_OBJECT (sheets_new_dialog), "entry_sheet_description", entry_sheet_description,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (entry_sheet_description);
  gtk_table_attach (GTK_TABLE (table1), entry_sheet_description, 1, 3, 4, 5,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_widget_set_usize (entry_sheet_description, 255, -2);
  gtk_widget_set_sensitive (entry_sheet_description, FALSE);

  label_svg_description = gtk_label_new (_("description:"));
  gtk_widget_ref (label_svg_description);
  gtk_object_set_data_full (GTK_OBJECT (sheets_new_dialog), "label_svg_description", label_svg_description,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label_svg_description);
  gtk_table_attach (GTK_TABLE (table1), label_svg_description, 0, 1, 1, 2,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_label_set_justify (GTK_LABEL (label_svg_description), GTK_JUSTIFY_RIGHT);
  gtk_misc_set_alignment (GTK_MISC (label_svg_description), 0.77, 0.5);

  dialog_action_area2 = GTK_DIALOG (sheets_new_dialog)->action_area;
  gtk_object_set_data (GTK_OBJECT (sheets_new_dialog), "dialog_action_area2", dialog_action_area2);
  gtk_widget_show (dialog_action_area2);
  gtk_container_set_border_width (GTK_CONTAINER (dialog_action_area2), 10);

  hbuttonbox1 = gtk_hbutton_box_new ();
  gtk_widget_ref (hbuttonbox1);
  gtk_object_set_data_full (GTK_OBJECT (sheets_new_dialog), "hbuttonbox1", hbuttonbox1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hbuttonbox1);
  gtk_box_pack_start (GTK_BOX (dialog_action_area2), hbuttonbox1, TRUE, TRUE, 0);
  gtk_button_box_set_layout (GTK_BUTTON_BOX (hbuttonbox1), GTK_BUTTONBOX_END);
  gtk_button_box_set_spacing (GTK_BUTTON_BOX (hbuttonbox1), 0);

  button_ok = gtk_button_new_from_stock(GTK_STOCK_OK);
  gtk_widget_ref (button_ok);
  gtk_object_set_data_full (GTK_OBJECT (sheets_new_dialog), "button_ok", button_ok,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (button_ok);
  gtk_container_add (GTK_CONTAINER (hbuttonbox1), button_ok);
  GTK_WIDGET_SET_FLAGS (button_ok, GTK_CAN_DEFAULT);

  button_cancel = gtk_button_new_from_stock(GTK_STOCK_CANCEL);
  gtk_widget_ref (button_cancel);
  gtk_object_set_data_full (GTK_OBJECT (sheets_new_dialog), "button_cancel", button_cancel,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (button_cancel);
  gtk_container_add (GTK_CONTAINER (hbuttonbox1), button_cancel);
  GTK_WIDGET_SET_FLAGS (button_cancel, GTK_CAN_DEFAULT);

  g_signal_connect (GTK_OBJECT (button_browse), "clicked",
                      G_CALLBACK (on_sheets_new_dialog_button_browse_clicked),
                      NULL);
  g_signal_connect (GTK_OBJECT (radiobutton_svg_shape), "toggled",
                      G_CALLBACK (on_sheets_new_dialog_radiobutton_svg_shape_toggled),
                      NULL);
  g_signal_connect (GTK_OBJECT (radiobutton_sheet), "toggled",
                      G_CALLBACK (on_sheets_new_dialog_radiobutton_sheet_toggled),
                      NULL);
  g_signal_connect (GTK_OBJECT (radiobutton_line_break), "toggled",
                      G_CALLBACK (on_sheets_new_dialog_radiobutton_line_break_toggled),
                      NULL);
  g_signal_connect (GTK_OBJECT (button_ok), "clicked",
                      G_CALLBACK (on_sheets_new_dialog_button_ok_clicked),
                      NULL);
  g_signal_connect (GTK_OBJECT (button_cancel), "clicked",
                      G_CALLBACK (on_sheets_new_dialog_button_cancel_clicked),
                      NULL);

  gtk_widget_grab_default (button_ok);
  return sheets_new_dialog;
}

GtkWidget*
create_sheets_edit_dialog (void)
{
  GtkWidget *sheets_edit_dialog;
  GtkWidget *dialog_vbox3;
  GtkWidget *vbox1;
  GtkWidget *frame_object;
  GtkWidget *table6;
  GtkWidget *label_object_description;
  GtkWidget *entry_object_description;
  GtkWidget *label_object_type;
  GtkWidget *entry_object_type;
  GtkWidget *frame_object_pixmap;
  GtkWidget *pixmap_object;
  GtkWidget *frame_sheet;
  GtkWidget *table3;
  GtkWidget *label_sheet_name;
  GtkWidget *entry_sheet_description;
  GtkWidget *label_sheet_description;
  GtkWidget *entry_sheet_name;
  GtkWidget *dialog_action_area3;
  GtkWidget *hbuttonbox2;
  GtkWidget *button_ok;
  GtkWidget *button_cancel;

  sheets_edit_dialog = gtk_dialog_new ();
  gtk_object_set_data (GTK_OBJECT (sheets_edit_dialog), "sheets_edit_dialog", sheets_edit_dialog);
  gtk_container_set_border_width (GTK_CONTAINER (sheets_edit_dialog), 5);
  gtk_window_set_title (GTK_WINDOW (sheets_edit_dialog), _("Edit Attributes"));
  gtk_window_set_role (GTK_WINDOW (sheets_edit_dialog), "sheets_edit_dialog");
  gtk_window_set_resizable (GTK_WINDOW (sheets_edit_dialog), FALSE);

  dialog_vbox3 = GTK_DIALOG (sheets_edit_dialog)->vbox;
  gtk_object_set_data (GTK_OBJECT (sheets_edit_dialog), "dialog_vbox3", dialog_vbox3);
  gtk_widget_show (dialog_vbox3);

  vbox1 = gtk_vbox_new (FALSE, 0);
  gtk_widget_ref (vbox1);
  gtk_object_set_data_full (GTK_OBJECT (sheets_edit_dialog), "vbox1", vbox1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (vbox1);
  gtk_box_pack_start (GTK_BOX (dialog_vbox3), vbox1, TRUE, TRUE, 0);

  frame_object = gtk_frame_new (_("DiaObject"));
  gtk_widget_ref (frame_object);
  gtk_object_set_data_full (GTK_OBJECT (sheets_edit_dialog), "frame_object", frame_object,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (frame_object);
  gtk_box_pack_start (GTK_BOX (vbox1), frame_object, TRUE, TRUE, 0);

  table6 = gtk_table_new (3, 2, FALSE);
  gtk_widget_ref (table6);
  gtk_object_set_data_full (GTK_OBJECT (sheets_edit_dialog), "table6", table6,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (table6);
  gtk_container_add (GTK_CONTAINER (frame_object), table6);
  gtk_container_set_border_width (GTK_CONTAINER (table6), 5);
  gtk_table_set_col_spacings (GTK_TABLE (table6), 6);

  label_object_description = gtk_label_new (_("Description:"));
  gtk_widget_ref (label_object_description);
  gtk_object_set_data_full (GTK_OBJECT (sheets_edit_dialog), "label_object_description", label_object_description,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label_object_description);
  gtk_table_attach (GTK_TABLE (table6), label_object_description, 0, 1, 1, 2,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label_object_description), 0, 0.5);

  entry_object_description = gtk_entry_new ();
  gtk_widget_ref (entry_object_description);
  gtk_object_set_data_full (GTK_OBJECT (sheets_edit_dialog), "entry_object_description", entry_object_description,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (entry_object_description);
  gtk_table_attach (GTK_TABLE (table6), entry_object_description, 1, 2, 1, 2,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);

  label_object_type = gtk_label_new (_("Type:"));
  gtk_widget_ref (label_object_type);
  gtk_object_set_data_full (GTK_OBJECT (sheets_edit_dialog), "label_object_type", label_object_type,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label_object_type);
  gtk_table_attach (GTK_TABLE (table6), label_object_type, 0, 1, 2, 3,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label_object_type), 0, 0.5);

  entry_object_type = gtk_entry_new ();
  gtk_widget_ref (entry_object_type);
  gtk_object_set_data_full (GTK_OBJECT (sheets_edit_dialog), "entry_object_type", entry_object_type,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (entry_object_type);
  gtk_table_attach (GTK_TABLE (table6), entry_object_type, 1, 2, 2, 3,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_widget_set_sensitive (entry_object_type, FALSE);
  gtk_entry_set_editable (GTK_ENTRY (entry_object_type), FALSE);

  frame_object_pixmap = gtk_frame_new (NULL);
  gtk_widget_ref (frame_object_pixmap);
  gtk_object_set_data_full (GTK_OBJECT (sheets_edit_dialog), "frame_object_pixmap", frame_object_pixmap,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (frame_object_pixmap);
  gtk_table_attach (GTK_TABLE (table6), frame_object_pixmap, 0, 1, 0, 1,
                    (GtkAttachOptions) (0),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_frame_set_shadow_type (GTK_FRAME (frame_object_pixmap), GTK_SHADOW_ETCHED_OUT);

  pixmap_object = create_pixmap (sheets_edit_dialog, NULL, FALSE);
  gtk_widget_ref (pixmap_object);
  gtk_object_set_data_full (GTK_OBJECT (sheets_edit_dialog), "pixmap_object", pixmap_object,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (pixmap_object);
  gtk_container_add (GTK_CONTAINER (frame_object_pixmap), pixmap_object);

  frame_sheet = gtk_frame_new (_("Sheet"));
  gtk_widget_ref (frame_sheet);
  gtk_object_set_data_full (GTK_OBJECT (sheets_edit_dialog), "frame_sheet", frame_sheet,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (frame_sheet);
  gtk_box_pack_start (GTK_BOX (vbox1), frame_sheet, TRUE, TRUE, 0);

  table3 = gtk_table_new (2, 2, FALSE);
  gtk_widget_ref (table3);
  gtk_object_set_data_full (GTK_OBJECT (sheets_edit_dialog), "table3", table3,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (table3);
  gtk_container_add (GTK_CONTAINER (frame_sheet), table3);
  gtk_container_set_border_width (GTK_CONTAINER (table3), 5);
  gtk_table_set_col_spacings (GTK_TABLE (table3), 6);

  label_sheet_name = gtk_label_new (_("Name:"));
  gtk_widget_ref (label_sheet_name);
  gtk_object_set_data_full (GTK_OBJECT (sheets_edit_dialog), "label_sheet_name", label_sheet_name,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label_sheet_name);
  gtk_table_attach (GTK_TABLE (table3), label_sheet_name, 0, 1, 0, 1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_label_set_justify (GTK_LABEL (label_sheet_name), GTK_JUSTIFY_RIGHT);
  gtk_misc_set_alignment (GTK_MISC (label_sheet_name), 0, 0.5);

  entry_sheet_description = gtk_entry_new ();
  gtk_widget_ref (entry_sheet_description);
  gtk_object_set_data_full (GTK_OBJECT (sheets_edit_dialog), "entry_sheet_description", entry_sheet_description,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (entry_sheet_description);
  gtk_table_attach (GTK_TABLE (table3), entry_sheet_description, 1, 2, 1, 2,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);

  label_sheet_description = gtk_label_new (_("Description:"));
  gtk_widget_ref (label_sheet_description);
  gtk_object_set_data_full (GTK_OBJECT (sheets_edit_dialog), "label_sheet_description", label_sheet_description,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label_sheet_description);
  gtk_table_attach (GTK_TABLE (table3), label_sheet_description, 0, 1, 1, 2,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label_sheet_description), 0, 0.5);

  entry_sheet_name = gtk_entry_new ();
  gtk_widget_ref (entry_sheet_name);
  gtk_object_set_data_full (GTK_OBJECT (sheets_edit_dialog), "entry_sheet_name", entry_sheet_name,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (entry_sheet_name);
  gtk_table_attach (GTK_TABLE (table3), entry_sheet_name, 1, 2, 0, 1,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_widget_set_usize (entry_sheet_name, 220, -2);

  dialog_action_area3 = GTK_DIALOG (sheets_edit_dialog)->action_area;
  gtk_object_set_data (GTK_OBJECT (sheets_edit_dialog), "dialog_action_area3", dialog_action_area3);
  gtk_widget_show (dialog_action_area3);
  gtk_container_set_border_width (GTK_CONTAINER (dialog_action_area3), 10);

  hbuttonbox2 = gtk_hbutton_box_new ();
  gtk_widget_ref (hbuttonbox2);
  gtk_object_set_data_full (GTK_OBJECT (sheets_edit_dialog), "hbuttonbox2", hbuttonbox2,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hbuttonbox2);
  gtk_box_pack_start (GTK_BOX (dialog_action_area3), hbuttonbox2, TRUE, TRUE, 0);
  gtk_button_box_set_layout (GTK_BUTTON_BOX (hbuttonbox2), GTK_BUTTONBOX_END);
  gtk_button_box_set_spacing (GTK_BUTTON_BOX (hbuttonbox2), 0);

  button_ok = gtk_button_new_from_stock(GTK_STOCK_OK);
  gtk_widget_ref (button_ok);
  gtk_object_set_data_full (GTK_OBJECT (sheets_edit_dialog), "button_ok", button_ok,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (button_ok);
  gtk_container_add (GTK_CONTAINER (hbuttonbox2), button_ok);
  GTK_WIDGET_SET_FLAGS (button_ok, GTK_CAN_DEFAULT);

  button_cancel = gtk_button_new_from_stock(GTK_STOCK_CANCEL);
  gtk_widget_ref (button_cancel);
  gtk_object_set_data_full (GTK_OBJECT (sheets_edit_dialog), "button_cancel", button_cancel,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (button_cancel);
  gtk_container_add (GTK_CONTAINER (hbuttonbox2), button_cancel);
  GTK_WIDGET_SET_FLAGS (button_cancel, GTK_CAN_DEFAULT);

  g_signal_connect (GTK_OBJECT (entry_object_description), "changed",
                      G_CALLBACK (on_sheets_edit_dialog_entry_object_description_changed),
                      NULL);
  g_signal_connect (GTK_OBJECT (entry_sheet_description), "changed",
                      G_CALLBACK (on_sheets_edit_dialog_entry_sheet_description_changed),
                      NULL);
  g_signal_connect (GTK_OBJECT (entry_sheet_name), "changed",
                      G_CALLBACK (on_sheets_edit_dialog_entry_sheet_name_changed),
                      NULL);
  g_signal_connect (GTK_OBJECT (button_ok), "clicked",
                      G_CALLBACK (on_sheets_edit_dialog_button_ok_clicked),
                      NULL);
  g_signal_connect (GTK_OBJECT (button_cancel), "clicked",
                      G_CALLBACK (on_sheets_edit_dialog_button_cancel_clicked),
                      NULL);

  gtk_widget_grab_default (button_ok);
  return sheets_edit_dialog;
}

GtkWidget*
create_sheets_remove_dialog (void)
{
  GtkWidget *sheets_remove_dialog;
  GtkWidget *dialog_vbox4;
  GtkWidget *frame;
  GtkWidget *table7;
  GSList *table7_group = NULL;
  GtkWidget *radiobutton_object;
  GtkWidget *frame_object_pixmap;
  GtkWidget *pixmap_object;
  GtkWidget *radiobutton_sheet;
  GtkWidget *entry_object;
  GtkWidget *entry_sheet;
  GtkWidget *dialog_action_area4;
  GtkWidget *hbuttonbox3;
  GtkWidget *button_ok;
  GtkWidget *button_cancel;

  sheets_remove_dialog = gtk_dialog_new ();
  gtk_object_set_data (GTK_OBJECT (sheets_remove_dialog),
                       "sheets_remove_dialog", sheets_remove_dialog);
  gtk_window_set_title (GTK_WINDOW (sheets_remove_dialog), _("Remove"));
  gtk_window_set_default_size (GTK_WINDOW (sheets_remove_dialog), 316, -1);
  gtk_window_set_role (GTK_WINDOW (sheets_remove_dialog),
                       "sheets_remove_dialog");
  gtk_window_set_resizable (GTK_WINDOW (sheets_remove_dialog), TRUE);

  dialog_vbox4 = GTK_DIALOG (sheets_remove_dialog)->vbox;
  gtk_object_set_data (GTK_OBJECT (sheets_remove_dialog), "dialog_vbox4", dialog_vbox4);
  gtk_widget_show (dialog_vbox4);

  frame = gtk_frame_new (_("Type"));
  gtk_widget_ref (frame);
  gtk_object_set_data_full (GTK_OBJECT (sheets_remove_dialog), "frame", frame,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (frame);
  gtk_box_pack_start (GTK_BOX (dialog_vbox4), frame, TRUE, TRUE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (frame), 5);

  table7 = gtk_table_new (3, 2, FALSE);
  gtk_widget_ref (table7);
  gtk_object_set_data_full (GTK_OBJECT (sheets_remove_dialog), "table7", table7,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (table7);
  gtk_container_add (GTK_CONTAINER (frame), table7);

  radiobutton_object = gtk_radio_button_new_with_label (table7_group, _("DiaObject:"));
  table7_group = gtk_radio_button_group (GTK_RADIO_BUTTON (radiobutton_object));
  gtk_widget_ref (radiobutton_object);
  gtk_object_set_data_full (GTK_OBJECT (sheets_remove_dialog), "radiobutton_object", radiobutton_object,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (radiobutton_object);
  gtk_table_attach (GTK_TABLE (table7), radiobutton_object, 0, 1, 1, 2,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);

  frame_object_pixmap = gtk_frame_new (NULL);
  gtk_widget_ref (frame_object_pixmap);
  gtk_object_set_data_full (GTK_OBJECT (sheets_remove_dialog), "frame_object_pixmap", frame_object_pixmap,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (frame_object_pixmap);
  gtk_table_attach (GTK_TABLE (table7), frame_object_pixmap, 0, 1, 0, 1,
                    (GtkAttachOptions) (0),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_frame_set_shadow_type (GTK_FRAME (frame_object_pixmap), GTK_SHADOW_ETCHED_OUT);

  pixmap_object = create_pixmap (sheets_remove_dialog, NULL, FALSE);
  gtk_widget_ref (pixmap_object);
  gtk_object_set_data_full (GTK_OBJECT (sheets_remove_dialog), "pixmap_object", pixmap_object,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (pixmap_object);
  gtk_container_add (GTK_CONTAINER (frame_object_pixmap), pixmap_object);

  radiobutton_sheet = gtk_radio_button_new_with_label (table7_group, _("Sheet:"));
  table7_group = gtk_radio_button_group (GTK_RADIO_BUTTON (radiobutton_sheet));
  gtk_widget_ref (radiobutton_sheet);
  gtk_object_set_data_full (GTK_OBJECT (sheets_remove_dialog), "radiobutton_sheet", radiobutton_sheet,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (radiobutton_sheet);
  gtk_table_attach (GTK_TABLE (table7), radiobutton_sheet, 0, 1, 2, 3,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);

  entry_object = gtk_entry_new ();
  gtk_widget_ref (entry_object);
  gtk_object_set_data_full (GTK_OBJECT (sheets_remove_dialog), "entry_object", entry_object,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (entry_object);
  gtk_table_attach (GTK_TABLE (table7), entry_object, 1, 2, 1, 2,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL), 0, 0);
  gtk_entry_set_editable (GTK_ENTRY (entry_object), FALSE);

  entry_sheet = gtk_entry_new ();
  gtk_widget_ref (entry_sheet);
  gtk_object_set_data_full (GTK_OBJECT (sheets_remove_dialog), "entry_sheet", entry_sheet,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (entry_sheet);
  gtk_table_attach (GTK_TABLE (table7), entry_sheet, 1, 2, 2, 3,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_entry_set_editable (GTK_ENTRY (entry_sheet), FALSE);

  dialog_action_area4 = GTK_DIALOG (sheets_remove_dialog)->action_area;
  gtk_object_set_data (GTK_OBJECT (sheets_remove_dialog), "dialog_action_area4", dialog_action_area4);
  gtk_widget_show (dialog_action_area4);
  gtk_container_set_border_width (GTK_CONTAINER (dialog_action_area4), 10);

  hbuttonbox3 = gtk_hbutton_box_new ();
  gtk_widget_ref (hbuttonbox3);
  gtk_object_set_data_full (GTK_OBJECT (sheets_remove_dialog), "hbuttonbox3", hbuttonbox3,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hbuttonbox3);
  gtk_box_pack_start (GTK_BOX (dialog_action_area4), hbuttonbox3, TRUE, TRUE, 0);
  gtk_button_box_set_layout (GTK_BUTTON_BOX (hbuttonbox3), GTK_BUTTONBOX_END);
  gtk_button_box_set_spacing (GTK_BUTTON_BOX (hbuttonbox3), 0);

  button_ok = gtk_button_new_from_stock(GTK_STOCK_OK);
  gtk_widget_ref (button_ok);
  gtk_object_set_data_full (GTK_OBJECT (sheets_remove_dialog), "button_ok", button_ok,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (button_ok);
  gtk_container_add (GTK_CONTAINER (hbuttonbox3), button_ok);
  GTK_WIDGET_SET_FLAGS (button_ok, GTK_CAN_DEFAULT);

  button_cancel = gtk_button_new_from_stock(GTK_STOCK_CANCEL);
  gtk_widget_ref (button_cancel);
  gtk_object_set_data_full (GTK_OBJECT (sheets_remove_dialog), "button_cancel", button_cancel,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (button_cancel);
  gtk_container_add (GTK_CONTAINER (hbuttonbox3), button_cancel);
  GTK_WIDGET_SET_FLAGS (button_cancel, GTK_CAN_DEFAULT);

  g_signal_connect (GTK_OBJECT (radiobutton_object), "toggled",
                      G_CALLBACK (on_sheets_remove_dialog_radiobutton_object_toggled),
                      NULL);
  g_signal_connect (GTK_OBJECT (radiobutton_sheet), "toggled",
                      G_CALLBACK (on_sheets_remove_dialog_radiobutton_sheet_toggled),
                      NULL);
  g_signal_connect (GTK_OBJECT (button_ok), "clicked",
                      G_CALLBACK (on_sheets_remove_dialog_button_ok_clicked),
                      NULL);
  g_signal_connect (GTK_OBJECT (button_cancel), "clicked",
                      G_CALLBACK (on_sheets_remove_dialog_button_cancel_clicked),
                      NULL);

  gtk_widget_grab_default (button_ok);
  return sheets_remove_dialog;
}

GtkWidget*
create_sheets_shapeselection_dialog (void)
{
  GtkWidget *sheets_shapeselection_dialog;
  GtkWidget *ok_button;
  GtkWidget *cancel_button1;

  sheets_shapeselection_dialog = gtk_file_selection_new (_("Select SVG Shape File"));
  gtk_object_set_data (GTK_OBJECT (sheets_shapeselection_dialog), "sheets_shapeselection_dialog", sheets_shapeselection_dialog);
  gtk_container_set_border_width (GTK_CONTAINER (sheets_shapeselection_dialog), 10);

  ok_button = GTK_FILE_SELECTION (sheets_shapeselection_dialog)->ok_button;
  gtk_object_set_data (GTK_OBJECT (sheets_shapeselection_dialog), "ok_button", ok_button);
  gtk_widget_show (ok_button);
  GTK_WIDGET_SET_FLAGS (ok_button, GTK_CAN_DEFAULT);

  cancel_button1 = GTK_FILE_SELECTION (sheets_shapeselection_dialog)->cancel_button;
  gtk_object_set_data (GTK_OBJECT (sheets_shapeselection_dialog), "cancel_button1", cancel_button1);
  gtk_widget_show (cancel_button1);
  GTK_WIDGET_SET_FLAGS (cancel_button1, GTK_CAN_DEFAULT);

  g_signal_connect (GTK_OBJECT (ok_button), "clicked",
                      G_CALLBACK (on_sheets_shapeselection_dialog_button_ok_clicked),
                      NULL);
  g_signal_connect (GTK_OBJECT (cancel_button1), "clicked",
                      G_CALLBACK (on_sheets_shapeselection_dialog_button_cancel_clicked),
                      NULL);

  return sheets_shapeselection_dialog;
}

