/* Multi LIST : listagem com colunas multiplas. Pierre J. LAVELLE

	Versao para compativeis com o PC  
	
   Compilacao com Compilador Microsoft V.5
   	cl [/W3] [/Ox] [/Fc] ml.c /c                   
  	link ml+int;


   Exemplos de uso :
   
	Obtencao do modo de uso :
		ml

	Listagem desse fonte com todos os "defaults" :
		ml ml.c
	
   	Listagem do codigo gerado pelo compilador :
		ml ml.cod n

	Listagem normal, como pelo comando "TYPE" :
		ml ml.c n c1 l132 h x
	
*/

char *versao = "18/02/88" ;

/* opcoes por omissao para uma impressora de 264 posicoes */

#define	deflarg	    87	/* largura util de cada coluna */
#define	defncol	     3	/* numero de colunas */
#define	defesp	     1	/* espaco entre colunas */
#define	defmarg	     1	/* margem esquerda */
#define defalgs	     4	/* numeracao com 4 algarismos */
#define defalt	    80	/* numero de linhas uteis por coluna */
#define defpripag    1	/* qual a primeira pagina a imprimir */
#define deftemcab    1	/* tem cabecalho */
#define defblock  4096  /* buffer do disco */

/* cadeias de controle da impressora */

/* 264 colunas, 88 linhas/pagina */
char *defsetup = "\x1e\x35\x1b\x30" ;

/* inicio do cabecalho. anula compressao, vai para negrito */
char *start = "\x12\x14\x0f\x0e" ;

/* fim do cabecalho. Volta ao normal, pula uma linha */
char *stop  = "\x14\x12\r\n\n" ;

int open ( char *, int ) ;
int read ( int, char *, unsigned int ); 
    
struct WORDREGS { unsigned int ax;
		  unsigned int bx;
		  unsigned int cx;
		  unsigned int dx;
		};
struct BYTEREGS { unsigned char al, ah;
		  unsigned char bl, bh;
		  unsigned char cl, ch;
		  unsigned char dl, dh;
		};
union REGS { struct WORDREGS x;
             struct BYTEREGS h;
           };        
union REGS inregs, outregs, timeregs ;

void int10 ( int );
char int160 ( void );
char int161 ( void );
int int17 ( char );
void int21 ( union REGS *, union REGS *);

char firstday [12] = { 5,1,1,4,6,2,4,0,3,5,1,3 };

/* pula fora */
void terminate (void);
void terminate()
      { inregs.x.ax = 0x4c00 ;
        int21( &inregs, &outregs );
      }

/* ler um caractere do teclado */
#define keyboard() int160()

/* teste se tem algo para pegar do teclado */
#define varredura() int161()

/* manda algo no VIDeo */
#define vid(c) int10(c)

/* VARIAVEIS GLOBAIS */
char *ip ;	/* ponteiro para a linha de comando */
char *pareaf;	/* ponteiro para o primeiro byte apos a area disponivel */
char *plf ; /* ponteiro de fim de leitura */

char buffer [ defblock ] ;
char iniprint [ 64 ] ;
char area [ 50000 ] ;

int file ; /* descritor do arquivo */
int page ; /* pagina atual */
int line ; /* numero da linha */
int col  ; /* 0 no inicio da linha, !0 dentro dela */
int larg   = deflarg ;/* largura das colunas */
int alt    = defalt  ; /* altura das colunas */
int marg   = defmarg ; /* margem esquerda */
int ncol   = defncol ; /* numero de colunas */
int esp    = defesp  ; /* espaco entre colunas */
int algs   = defalgs ; /* numero de algarismos para numeracao */
int pripag = defpripag ; /* numero da primeira pagina */
int temcab = deftemcab ; /* se tem cabecalho */
int y,m,d ;

/* FUNCOES GLOBAIS */

/* GET DATA do arquivo a imprimir */
char *getdata (void);
char *getdata ()
     { int resp;
       resp = read ( file, buffer, (unsigned int) 4096 );
       /* erro ? */
       if ( resp < 0 ) terminate ();
       /* se o arquivo esta' sem ctrl-Z */
       if ( resp == 0 ) *buffer = '\x1a' ;
       plf = buffer + resp ;
       return buffer ;
     }

/* manda no VIDeo um String */
void vids ( char *pt )
     { char *rpt ;
       rpt = pt ;
       while ( *rpt ) vid ( *rpt++ ) ;
     }

/* ESPERA qq chave e sai */
void espera (void);
void espera()
     { vids ("\r\n\nAperte qualquer chave para sair");
       keyboard();
       terminate();
     }

/* manda algo no PRINTer */
void print( char c )
      { int t ;
	t = 10 ;
	while ( t-- && ( int17(c) & 0x0100 ) ) ;
	if ( t <= 0 )
	      { vids ( "TIME-OUT NA IMPRESSORA !!!" );
		espera () ;
	      }
      }

/* PRint String */
void prs ( char *pt )
     { char *rpt ;
       rpt = pt ;
       while ( *rpt ) print ( *rpt++ ) ;
     }  
       		     
/* TO UPPER case */
char toupper ( char c )
     { return (((c>='a')&&(c<='z')) ? c - ' ': c);
     }

/* PRint String em UPPER case */
void prsupper ( char *pt )
     { char *rpt ;
       rpt = pt ;
       while ( *rpt ) print ( toupper ( *rpt++ ) ) ;
     }

/* IS HEX : verifique se um caractere e hexa ou nao */
int  ishex ( char c )
     { return ((c>='0')&&(c<='9'))
           || ((c>='A')&&(c<='F')) ;
     }

/* transforme um Caractere Hexadecimal para BINario */
char chbin ( char c )
     { return c - ( ( c > '9' ) ? '7' : '0' ) ;
     }

/* PEGa um INTeiro da linha de comando apontada por *ip */
int pegint (void);
int pegint ( )
     { int x ; char a ;
       x = 0 ;
       while (((a=*++ip)>='0')&&(a<='9'))
             x = x * 10 + (int)( a - '0' );
       return x ;
     }

/* PEGa um byte em HEXa da linha apontada por *ip */
char peghex (void);
char peghex ()
     { char x , c1 , c2 ;
       x = 0 ;
       if ( ishex ( c1 = toupper ( *++ip ) ) )
          if ( ishex ( c2 = toupper ( *++ip ) ) )
             x = ( chbin ( c1 ) << 4 ) | chbin ( c2 ) ;
       return x ;
     }

/* manda um digito hexa */
void vidhexdig ( char x )
      { vid ( x + ( ( x > 9 ) ? '7' : '0' ) ) ;
      }
      
/* manda no video um car. hexa */
void vidhex ( char x )
      { vidhexdig ( x >> 4 ) ;
        vidhexdig ( x & 15 ) ;
      }
              
/* manda no VIDeo um numero DECimal n [ 1...32767 ],
   com suppressao dos zeros a esquerda. Tambem recursiva. */
void viddec ( int n )   
     { if ( n / 10 ) viddec ( n / 10 ) ;
       vid ( (char) ( n % 10 ) + '0' ) ;
     }

/* PRint um numero DECimal n [ 0...99 ] com exatamente dois algarismos */
void prdec2 ( int n )
     { print ( (char) ( n / 10 ) + '0' ) ;
       print ( (char) ( n % 10 ) + '0' ) ;
     }   

/* para mostrar o valor dos parametros */
void outpar ( int n )
     { vids (" [ ");
       viddec ( n ) ;
       vids (" ]\r\n");
     }
            	
/* imprime uma FOLHA completa */
char *folha ( char *cab )
     { register char *rpe , *rpef ;
       register int x, co, li ;
       if ( ++page >= pripag )
	   {  /* cabecalho opcional */
              if ( temcab )
		 { prs ( start ) ;
                   prsupper ( cab ) ;
		   prs ( "  ( pagina " );
		   prdec2 ( page );
		   /* get time */
		   inregs.h.ah = 0x2c ;
		   int21 ( &inregs, &timeregs ) ;
		   /* ch = horas      00...23
		      cl = minutas    00...59
		      dh = segundos   00...59
		      dl = centesimos 00...99	
                   */
                   prs ( " ) a\b`s " ) ;
                   prdec2 ( timeregs.h.ch ) ;
                   print ( ':' ) ;
                   prdec2 ( timeregs.h.cl ) ;

/*
                   print ( ':' ) ;
                   prdec2 ( timeregs.h.dh ) ;
                   print ( '.' ) ;
                   prdec2 ( timeregs.h.dl ) ;
*/
                   prs ( " hs d" ) ;
		   /* get date */
		   inregs.h.ah = 0x2a ;
		   int21 ( &inregs, &timeregs ) ;
		   /* cx = ano 1980...2099
		      dh = mes 01...12
		      dl = dia 01...31
		   */
		   y = timeregs.x.cx ;
		   m = timeregs.h.dh ;
		   d = timeregs.h.dl ;
                   rpe ="o Domingo\0a Segunda-feira\0\
a Terc\b,a-feira\0a Quarta-feira\0a Quinta-feira\0\
a Sexta-feira\0o Sa\b'bado" ;
		   /* obtem um numero na faixa 1...7 */
		   x=1+(d+firstday[m-1]+y+(y-1)/4+(((y%4)|(m<3))?0:1))%7;
		   while ( --x ) while ( *rpe++ ) ;
                   prs ( rpe ) ;
                   print ( ' ' ) ;
                   prdec2 ( d ) ;
                   prs ( " de " ) ;
                   rpe ="Janeiro\0Fevereiro\0Marc\b,o\0Abril\0Maio\0\
Junho\0Julho\0Agosto\0Setembro\0Outubro\0Novembro\0Dezembro" ;
		   while ( --m ) while ( *rpe++ ) ;
                   prs ( rpe ) ;
                   prs ( " de 19" ) ;
                   prdec2 ( y % 100 ) ;
                   prs ( stop ) ;
                   prs ( iniprint ) ;
                 }
              /* para todas as linhas... */
              for ( li = (int)0 ; li < alt ; ++li )
                  { 
                  /* para todas as colunas... */
                  for ( co = (int)0 ; co < ncol ; ++co )
                      { /* espaco entre as colunas */
                        x = co ? esp : marg ;
                        while ( x-- ) print ( ' ' ) ;
                        /* aponta a celula a imprimir */
                        rpef=larg+(rpe=area+larg*(li+(co*alt)));
                        /* enfim, imprime... */
                         while ( rpe != rpef ) print ( *rpe++ ) ;
                      }
                  /* fim de uma linha. CR LF */
                   prs ( "\r\n" ) ;
		  /* teste se alguma tecla foi usada */
		   if ( !varredura() )
		      { print (12);
			vids ("\r\nInterrompido.\r\n");
		        terminate();
		      }
		}
            /* fim de uma pagina. FF */
            print ( 12 ) ;
           }
       /* prepare para receber a proxima garfada */
       return area ;
     }

/******* PROGRAMA PRINCIPAL *******/
main ( int argc , char *argv[] )
{
register char *pl ;/* ponteiro de leitura */
register char *pe ;/* ponteiro de escrita */

int divisor;
char *pei ;/* inicio da celula */
char *pef ;/* apos o fim da celula */

int maxdiv, nb , x;

/* copia o string de inicializacao default */
pl = defsetup ;
pe = iniprint ;
while ( *pe++ = *pl++ );

/* verifique se tem o nome do arq. senao manda menu */
if ( argc < (2) )
   { vids ("\r\nUSO: MLIST nomearq opcoes\r\n\n\Versao do " ) ;
     vids ( versao ) ;
     vids ("\r\n\nOPCOES: em qualquer ordem, separadas por um espaco\r\n\
Prefixo '-' opcional e inutil\r\n\n\
N    Nao numera as linhas\r\n\
S    Sem cabecalho de pagina\r\n\
Lxx  Largura das colunas"); outpar ( deflarg ) ;
      vids ("Cxx  numero de Colunas"); outpar ( defncol ) ;
      vids ("Axx  Altura da folha"); outpar ( defalt ) ;
      vids ("Mxx  Margem esquerda"); outpar ( defmarg ) ;
      vids ("Exx  Espaco entre colunas"); outpar ( defesp ) ;
      vids ("Nxx  Numera linhas com xx algarismos"); outpar ( defalgs ) ;
      vids ("Hxx  Hexa para programar a impressora [ ");
      					pl = iniprint ;
      					while ( *pl ) vidhex ( *pl++ ) ;
      					vids ( " ]\r\n");
      vids ("Rxx  Refaz desde a pagina xx"); outpar ( pripag ) ;
      return 0 ;
   }

/* tenta abrir o arquivo */
if ( ( file = open ( argv[1] , (int)0x8000 ) ) == -1 )
   { vids ("****** NAO ACHEI ") ;
     vids ( argv[1] ) ;
     vids (" ******") ;
     return 0 ;
   }

/* pega os parametros opcionais */
while ( --argc > 1 )
      switch ( toupper ( *(ip = argv [ argc ] ) ) )
             { case 'L': larg = pegint () ; break ;
               case 'C': ncol = pegint () ; break ;
               case 'A': alt  = pegint () ; break ;
               case 'M': marg = pegint () ; break ;
               case 'E': esp  = pegint () ; break ;
               case 'N': algs = pegint () ; break ;
	       case 'R': pripag = pegint () ; break ;
               case 'S': temcab = pegint () ; break ;
               case 'H': pe = iniprint; while (*pe++=peghex ());break;
	       default : vids ("Parametro invalido: ");
	       		 vids ( ip );
	       		 espera();	
             } 

/* inicializa maxdiv */
maxdiv = 1 ;
if ( nb = algs ) while ( --nb ) maxdiv *= 10 ;

/* vamos la... */
vids ("Usando ");
viddec ( marg + ncol * larg + ( ncol - 1 ) * esp ) ;
vids (" colunas. Qualquer tecla pare a impressao ");

/* inicialisa a impressora */
prs ( iniprint ) ;

/* inicialisa o laco principal */
page = line = col = 0 ;
pef = larg + ( pe = pei = area ) ;
pareaf = area + ( larg * alt * ncol );
pl = getdata () ;

/* LACO PRINCIPAL ate marca de fim = ctrl-Z */
while ( *pl != '\x1a' )
      { if ( *pl == '\x0c' )	/* FORM FEED */
           { /* transforme FF em CR */
             ++*pl ;
             nb = ( pef - area ) / larg ;
             if ( nb %= alt ) pef += ( alt - nb ) * larg ;
           }

	nb = 1 ;
        if ( *pl == '\x09' )     /* TAB */
           { /* numeros de brancos a tratar agora */
             nb = 8 - ( col & 7 ) ;
             /* converte TAB num branco */
             *pl = ' ' ;
           }
                
        /* agora o verdadeiro trabalho */
        while ( nb-- )
              { /* teste se area cheia */
                if ( ( pe == pei ) && algs )
                   { ++line ;
                     divisor = maxdiv ;
                     while ( divisor )
                     	{ x = line / divisor ;
                     	  *pe++ = (char)( x ? (x%10) + '0' : ' ' );
                     	  divisor /= 10 ;
                     	}
                     *pe++ = ':';
                     *pe++ = ' ';	  	
                   }
                
                /* carriage return ? */
                if ( *pl == 0x0d )
                   { col = 0 ;
                     while ( pe != pef ) *pe++ = ' ' ;
                   }       
                
                /* fim da celula ? */
                if ( pe == pef )
                   { pei = pe ;   
                     pef += larg ;
                     if ( pe == pareaf )
                        pef = larg + ( pei = pe = folha ( argv[1] ) ) ;
                     if ( col )
                        { divisor = algs + 2 ;
                          while ( divisor-- ) *pe++ = ' ' ;
                        }
                   }
                             
                /* se caractere imprimivel */
                if ( *pl & 0x60 )
                   { *pe++ = *pl ;
                     col++ ;
                   }
              }
        if ( ++pl == plf ) pl = getdata () ;
      }                 

/* acabe a ultima folha ( se houver ) */
if ( pe != area )
   { while ( pe != pareaf ) *pe++ = ' ' ;
     folha ( argv[1] ) ;
   }

/* reset the printer */
print ( '\x1b' ) ;
print ( '@' ) ;
return 0 ;
}
