package sudoku.jogo;
import java.util.LinkedList;

/*
 * Created on 17/08/2007
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */

public class Celula {
	
	private int cordX;
	private int cordY;
	private LinkedList<Integer> valoresPossiveis;
	private LinkedList<Integer> valoresPossiveisAux;
	private int custo;
	private Integer valor;
	private int tamanho;
	private boolean verificado;
	
	private boolean fixo;
	
	public Celula(int x, int y, int tam){
	
		this.verificado = false;
		this.tamanho = tam;
		this.cordX = x;
		this.cordY = y;
		this.valor = 0;
		this.valoresPossiveis = carregaValores();
		this.valoresPossiveisAux = carregaValores();
		this.custo = valoresPossiveis.size();
		this.fixo = false;
	}
	
	public boolean isFixo() {
		return fixo;
	}

	public void setFixo(boolean fixo) {
		this.fixo = fixo;
	}

	private LinkedList<Integer> carregaValores() {
		
		LinkedList<Integer> lista = new LinkedList<Integer>();
		for(int i = 1 ; i <= tamanho; i ++) lista.add(new Integer(i));
		return lista;
	}

	public void setCusto(){
		this.custo = valoresPossiveis.size();
	}
	
	public void addValor(Integer novo){
		
		setVerificado();
		this.valoresPossiveisAux.addLast(novo);
		this.valoresPossiveis = new LinkedList<Integer>(valoresPossiveisAux);
		setCusto();
	}
	
	public int pertence(Integer valor){
		for(int i = 0; i < valoresPossiveis.size() ; i++){
			if(valoresPossiveis.get(i).intValue() == valor.intValue()) return i;
		}
		return -1;
	}
	
	public void removeValor(Integer valor){
		int pos = pertence(valor);
		if(this.valoresPossiveisAux.contains(valor)){
			this.valoresPossiveisAux.remove(valor);
		}
		if(pos >= 0) {
			this.valoresPossiveis.remove(pos);
			
			setCusto();
		}

	}
	
	public void limpaList(){
		this.valoresPossiveis.clear();
		setCusto();
	}
	
	public int getX(){
		return this.cordX;
	}
	
	public int getY(){
		return this.cordY;
	}
	
	public int getCusto(){
		return this.custo;
	}
	
	public boolean setValor(Integer valor){
		if(isFixo()){
			return false;
		}
		if(pertence(valor)>=0) {
			this.valor = valor;
			limpaList();
			this.valoresPossiveisAux.remove(valor);
			setVerificado();
			return true;
		} else if(valor == 0) {
			this.valor = valor;
			setVerificado();
			return true;
		}
		return false;
	}
	
	public Integer getValor(){
		return this.valor;
	}
	
	public void setVerificado(){
		if(this.verificado)this.verificado = false;
		else this.verificado = true;
	}
	
	public boolean isVerificado(){
		return this.valor != 0;
	}
	
	public LinkedList<Integer> getValoresPossiveis(){
		return this.valoresPossiveis;
	}
	
	public LinkedList<Integer> getValoresPossiveisAux(){
		return this.valoresPossiveisAux;
	}
	
	public String toString(){
		return this.cordX + "x" + this.cordY + "=" +this.valor + "-" + listaPossiveis();
	}
	
	private String listaPossiveis(){
		String result = "[";
		for(int i = 0 ; i < this.valoresPossiveis.size() ; i++){
			result += valoresPossiveis.get(i) + " ";
		}
		return result.trim() + "]";
	}
}
