/**
 * 
 */
package sudoku.gui;

import java.awt.GridLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

import sudoku.jogo.Celula;
import sudoku.jogo.ITabuleiroListener;
import sudoku.jogo.TabuleiroEvent;

/**
 * @author alan
 *
 */
public class TabuleiroFrame extends JFrame implements ITabuleiroListener {

	private static final int TAMANHO = 9;
	
	private JPanel panelTabuleiro;
	private JButton[][] botoes;
	private TabuleiroController controller;
	
	/**
	 * 
	 */
	public TabuleiroFrame() {
		super("SudokuSolver");
		this.controller = new TabuleiroController(TAMANHO);
		init();
		setSize(400, 300);
		controller.addTabuleiroListener(this);
		controller.updateJogo();
	}
	
	
	private void init() {
		
		GraficMenu barraDeMenu = new GraficMenu(controller);
		this.setJMenuBar(barraDeMenu);
		
		this.panelTabuleiro = new JPanel();
		this.panelTabuleiro.setLayout(new GridLayout(TAMANHO, TAMANHO));
		this.botoes = new JButton[TAMANHO][TAMANHO];
		
		for (int i = 0; i < TAMANHO; i++) {
			for (int j = 0; j < TAMANHO; j++) {
				TabuleiroButton btn = createButton(i, j);
				panelTabuleiro.add(btn);
				botoes[i][j] = btn;
			}
		}
		add(this.panelTabuleiro);
		
		addWindowListener(new WindowAdapter(){
			@Override
			public void windowClosing(WindowEvent e) {
				System.exit(0);
			}
			
		});
		
	}


	private TabuleiroButton createButton(int i, int j) {
		final TabuleiroButton btn = new TabuleiroButton(i, j, controller.getQuadrante(i, j));
		btn.addMouseListener(new MouseAdapter(){
			@Override
			public void mouseClicked(MouseEvent e) {
				controller.increment(btn.getCordX(), btn.getCordY());
			}
		});
		btn.setFocusable(false);
		return btn;
	}


	public static void main(String[] args) {
		new TabuleiroFrame().setVisible(true);
	}


	public void update(TabuleiroEvent event) {
		if(event.getSource() instanceof Celula[][]) {
			Celula[][] tabuleiro = (Celula[][]) event.getSource();
			for (int i = 0; i < TAMANHO; i++) {
				for (int j = 0; j < TAMANHO; j++) {
					StringBuffer str = new StringBuffer("<html>");
					if (tabuleiro[i][j].getValor() != 0) {
						str.append("<div align=\"center\">");
						str.append(tabuleiro[i][j].getValor());
						str.append("</div>");								
					}
					if (SudokuConfig.getInstance().isDebug()) {
						str.append("<BR>");		
						str.append(tabuleiro[i][j].getValoresPossiveis());					
					}
					str.append("</html>");
					this.botoes[i][j].setText(str.toString());
					if(tabuleiro[i][j].isFixo()){
						this.botoes[i][j].setEnabled(false);
					} else {
						this.botoes[i][j].setEnabled(true);
					}
				}
			}	
		}
		if(event.getSource().equals("Ganhou")) {
			terminaJogo();
			return;
		}
	}

	private void terminaJogo() {
		for (int i = 0; i < botoes.length; i++) {
			for (int j = 0; j < botoes.length; j++) {
				botoes[i][j].setEnabled(false);
			}
		}
		JOptionPane.showMessageDialog(this, "PARABNS!!! Voc ganhou o jogo!");
	}

}
