/**
 * 
 */
package sudoku.gui;

import java.util.ArrayList;
import java.util.List;

import sudoku.jogo.ITabuleiroListener;
import sudoku.jogo.Tabuleiro;

/**
 * @author alan
 *
 */
public class TabuleiroController {

	private Tabuleiro tabuleiro;
	private int tamanho;
	private List<ITabuleiroListener> tabuleiroListener;
	
	/**
	 * 
	 */
	public TabuleiroController(int tamanho) {
		this.tabuleiro = new Tabuleiro(tamanho);
		this.tamanho = tamanho;
		this.tabuleiroListener = new ArrayList<ITabuleiroListener>();
	}

	public void addTabuleiroListener(ITabuleiroListener listener) {
		this.tabuleiro.addTabuleiroListener(listener);
		this.tabuleiroListener.add(listener);
	}
	
	public void increment(int x, int y) {
		int valor = this.tabuleiro.getValor(x, y) + 1;
		while (!tabuleiro.getTabuleiro()[x][y].getValoresPossiveisAux().contains(valor) ) {
			valor++;
			if(valor > tamanho) {
				valor = 0;
				break;
			}
		}
		
		this.tabuleiro.setValor(x, y, valor);
	}

	public int getQuadrante(int i, int j) {
		return this.tabuleiro.getQuadrante(i,j);
	}

	public void novoJogo() {
		this.tabuleiro = new Tabuleiro(tamanho);
		for (ITabuleiroListener listener : this.tabuleiroListener) {
			this.tabuleiro.addTabuleiroListener(listener);
		}
		this.tabuleiro.notifyListeners();
	}

	public void updateJogo() {
		this.tabuleiro.notifyListeners();
	}

	public void solve() {
		this.tabuleiro.solve();
	}
	
}
