package sudoku.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;

/**
 * Interface Grfica para o menu da janela.
 * @author alan
 */
public class GraficMenu extends JMenuBar implements ActionListener {

	/**
	 * 
	 */
	private static final long serialVersionUID = 4835703000711801131L;

	private JMenu menuJogo, menuAjuda;

	private final String LINHA = System.getProperty("line.separator");
	private final String INSTRUES = 

		"O sudoku consiste em preencher uma grade de 81 espaos dividida em " + LINHA +
		"nove blocos. O objetivo do jogo  completar os espaos em branco " + LINHA +
		"com algarismos de 1 a 9, de modo que cada nmero aparea apenas uma " + LINHA +
		"vez na linha, quadrante e coluna. Nenhum nmero pode ser repetido e " + LINHA +
		"todos os nmeros de 1 a 9 devem estar presentes." + LINHA + LINHA +
		"Para atribuir um valor  uma clula basta clic-la at chegar ao valor " + LINHA +
		"desejado. O jogo termina quando todas as clulas esto preenchidas " + LINHA +
		"satisfazendo todas as restries.";

	private final String DESENVOLVIMENTO = 

		"Universidade Federal de Campina Grande" + LINHA +
		"Curso de Cincia da Computao " +  LINHA +
		"Inteligncia Artificial I" + LINHA +
		"Prof.: Joseana Macdo Fechini" + LINHA +  LINHA +
		"      SudokuSolver" + LINHA +
		"      Verso 1.0 (2007)" + LINHA +  LINHA +
		"Desenvolvedores:" + LINHA +
		"      Cicero Alan Leite Cruz"+ LINHA +
		"      Emanuel Dantas Filho" + LINHA +
		"      Fbio Jorge A. Morais" + LINHA +
		"      Tiago Lucas P. Clementino";

	private TabuleiroController controller;

	
	/**
	 * Construtor para o menu grfico
	 * @param controller 
	 */
	public GraficMenu(TabuleiroController controller){

		super();
		this.controller = controller;

		menuJogo = new JMenu("Jogo");
		menuJogo.setMnemonic('J');

		JMenuItem novoItem = new JMenuItem("Novo");
		novoItem.setMnemonic('N');
		novoItem.addActionListener(this);
		menuJogo.add(novoItem);
		
		final JCheckBoxMenuItem debugItem = new JCheckBoxMenuItem("Modo debug");
		debugItem.setMnemonic('d');
		debugItem.addActionListener(this);
		menuJogo.add(debugItem);

		JMenuItem solveItem = new JMenuItem("Solve");
		solveItem.setMnemonic('v');
		solveItem.addActionListener(this);
		menuJogo.add(solveItem);
		
		menuJogo.addSeparator();
		
		JMenuItem exitItem = new JMenuItem("Sair");
		exitItem.setMnemonic('S');
		exitItem.addActionListener(this);
		menuJogo.add(exitItem);

		menuAjuda = new JMenu("Ajuda");
		menuAjuda.setMnemonic('A');

		JMenuItem instrucoesItem = new JMenuItem("Instrues");
		instrucoesItem.setMnemonic('I');
		instrucoesItem.addActionListener(this);
		menuAjuda.add(instrucoesItem);

		menuAjuda.addSeparator();

		JMenuItem aboutItem = new JMenuItem("Sobre...");
		aboutItem.setMnemonic('S');
		aboutItem.addActionListener(this);
		menuAjuda.add(aboutItem);

		this.add(menuJogo);
		this.add(menuAjuda);

	}

    public void actionPerformed(ActionEvent evt) {
    	String arg = evt.getActionCommand();
    	if (arg.equals("Novo")){
    		this.controller.novoJogo();
    	} else if (arg.equals("Modo debug")){
    		boolean debug = ((JCheckBoxMenuItem)evt.getSource()).getState();
			SudokuConfig.getInstance().setDebug(debug);
			this.controller.updateJogo();
		} else if (arg.equals("Sair")){
			System.exit(0);
		}else if (arg.equals("Solve")){
			this.controller.solve();
		} else if (arg.equals("Instrues")){
			JOptionPane.showMessageDialog(null,INSTRUES,"Instrues",
					JOptionPane.PLAIN_MESSAGE);
		} else if (arg.equals("Sobre...")){
			JOptionPane.showMessageDialog(null,DESENVOLVIMENTO,"Sobre...",
					JOptionPane.PLAIN_MESSAGE);
		}
    	
    }
	
}